import { Box } from "../Box.mjs";
import { Vec } from "../Vec.mjs";
import { Polygon2d } from "./Polygon2d.mjs";
class Rectangle2d extends Polygon2d {
  x;
  y;
  w;
  h;
  constructor(config) {
    const { x = 0, y = 0, width, height } = config;
    super({
      ...config,
      points: [
        new Vec(x, y),
        new Vec(x + width, y),
        new Vec(x + width, y + height),
        new Vec(x, y + height)
      ]
    });
    this.x = x;
    this.y = y;
    this.w = width;
    this.h = height;
  }
  getBounds() {
    return new Box(this.x, this.y, this.w, this.h);
  }
  getSvgPathData() {
    const { x, y, w, h } = this;
    return `M${x},${y} h${w} v${h} h-${w}z`;
  }
}
export {
  Rectangle2d
};
//# sourceMappingURL=Rectangle2d.mjs.map
